import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {graphql, compose} from "react-apollo";
import gql from "graphql-tag";
import {Form, TextArea} from 'react-form';
import Loading from "../../../../core/Loading/Loading";
import DocumentsForm from "../../../../core/Forms/DocumentsForm/DocumentsForm";
import {rolesQuery} from "../../../../api/queries";

export default class Create extends Component {

  constructor(props) {
    super(props);

    this.state = {
      submitting: false,
      error: false,
    };
  }

  render() {

    return (
      <div className="container" style={{marginBottom: '20px'}}>
        <h1>Nuovo Documento</h1>
        <DocumentsForm
          errorMessage={"Errore durante la creazione del documento"}
          data={this.props.data}
          submitMutation={gql`
                    mutation($documento: DocumentoInput) {
                        updateDocumento(documento: $documento) {
                            id
                        }
                    }`} />
      </div>
    )
  }
}

Create.defaultProps = {};

Create.propTypes = {};
